 ; Ŀ
 ;   Sarn: search and replace block names.                                 
 ;   Copyright 2005 by Rocket Software Ltd.                                
 ;                                                                         
 ;   Contains utilities:                                                   
 ;   Sloot: print all block table header data.                             
 ;   Sara: convert all layer names to initial capitals.                    
 ; 

 ; Ŀ
 ;   Sloot: an invisible utility: print block table data.                  
 ; 
 (DEFUN C:SLOOT (/ rew dat)
  (setq rew T)
  (while (setq dat (tblnext "block" rew))
         (if dat (print dat))
         (setq rew ()))
  (textscr)
 (princ))
 ; Ŀ
 ;   Sloot end.                                                            
 ; 

 ; Ŀ
 ;   Sara - utility - convert all block names to initial capitals.         
 ; 
 (DEFUN C:SARA (/ rew llist blnam gnunam)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   Step through the block tables and impart rationality.                 
 ; 
  (setq rew t)
  (while (setq llist (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (setq asoc2 (assoc 2 llist))))
         (setq gnunam (fdash (list " " "-" "/") blnam))
         (command ".rename" "block" blnam gnunam))
 (princ))
 ; Ŀ
 ;   Sara end.                                                             
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Hug - string capitaliser.  Takes one argument, a string, and returns  
 ;   a list: the string with the first letter changed to upper case and    
 ;   T if this changed the string, () if not.                              
 ; 
 (DEFUN HUG (exstr / nustr)
  (setq nustr (strcat (strcase (substr exstr 1 1))
                      (strcase (substr exstr 2) t)))
 (list nustr (if (= exstr nustr) () t)))
 ; Ŀ
 ;   Hug - end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Fdash - split a string at any character in a list,         
 ;   capitalise each resulting substring, reassemble the string.           
 ;   Also watches for certain special cases.                               
 ;   Arguments: Astr: the string to process.                               
 ;              Chra: the list of separator characters.                    
 ;   Recursive.                                                            
 ; 
 (DEFUN FDASH (chra astr / sub prlist nustra nump)
  (if (and astr 
           (car chra)
           (> (length (setq prlist (splat (car chra) astr))) 0))
      (progn
           (setq nustra "")
           (while (setq sub (car prlist))
                  (setq prlist (cdr prlist))
                  (setq sub (strcase sub t))
                  (cond ((= (substr sub 1 1) "(")               ; balance: )
                         (setq sub (strcat "(" (car (hug (substr sub 2)))))) ;)
                        ((or (and (> (setq nump (sonar "." sub t)) 0)
                                  (/= (substr sub (strlen sub)) "."))
                             (> nump 1))
                         (setq sub (strcase sub)))
                        ((member sub '("vsat" "mds" "vavcu"))
                         (setq sub (strcase sub)))
                        (T (setq sub (car (hug sub)))))
                  (setq sub (fdash (cdr chra) sub))             ; recurse
                  (setq nustra (strcat nustra (car chra) sub)))
           (if (= (substr nustra 1 1) (car chra))
               (setq nustra (substr nustra 2))))
      (setq nustra astr))
 nustra)
 ; Ŀ
 ;   Fdash.                                                                
 ; 

 ; Ŀ
 ;   Sonar - see if a string contains a substring.                         
 ;   Arguments:  Loc, the substring.                                       
 ;               Txt, the string.                                          
 ;               Cas, if this is non-nil then the search                   
 ;                                is non-case-sensitive.                   
 ;   Returns the number of occurrences of the substring.                   
 ; 
 (DEFUN SONAR (loc txt cas / chflg ln sta st)
  (setq chflg 0)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg (1+ chflg)))
         (setq sta (1+ sta)))
 chflg)
 ; Ŀ
 ;   Sonar end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen linn))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Sarn.                                                                 
 ; 
 (DEFUN C:SARN (/ oldstr newstr cas rew blnam chugs gnunam)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq oldstr (getstring t "Old string: "))
  (setq newstr (getstring t "New string: "))
  (initget 0 "Yes No")
  (setq cas (getkword "Case Sensitive <Yes>/No: "))
 ; Ŀ
 ;   Step through the layer tables and impart rationality.                 
 ; 
  (setq rew t)
  (while (setq llist (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (assoc 2 llist)))
         (if (or (null cas) (= cas "Yes"))
             (setq chugs (chug oldstr newstr blnam))
             (setq chugs (chug (strcase oldstr) newstr (strcase blnam))))
         (if (< 0 (cadr chugs))
             (progn
                  (setq gnunam (car chugs))
                  (command ".rename" "block" blnam gnunam))))
 (princ))